#!/bin/bash

# Exit immediately if a command exits with a non-zero status
set -e

echo "Waiting for PostgreSQL..."
while ! nc -z $POSTGRES_HOST $POSTGRES_PORT; do
  sleep 0.5
done
echo "PostgreSQL is ready."

# --- CHICKEN & EGG FIX ---
# Check if the accounts migration exists. If not, make it.
if [ ! -f "apps/accounts/migrations/0001_initial.py" ]; then
    echo "No migrations found for 'accounts'. Creating them now..."
    python manage.py makemigrations accounts
    python manage.py makemigrations # Catch any other apps
else
    echo "Migrations already exist. Skipping makemigrations."
fi
# -------------------------

echo "Applying database migrations..."
python manage.py migrate --noinput

echo "Collecting static files..."
python manage.py collectstatic --noinput

echo "Starting Gunicorn..."
exec gunicorn config.wsgi:application \
    --bind 0.0.0.0:8000 \
    --workers 3 \
    --reload