import asyncio
import logging
from django.core.management.base import BaseCommand
from apps.telegram_bot.loader import bot, dp
from apps.telegram_bot.handlers import router as main_router
from apps.telegram_bot.middlewares.auth import DjangoUserMiddleware
from apps.telegram_bot.middlewares.throttling import ThrottlingMiddleware

class Command(BaseCommand):
    help = "Runs the Telegram Bot (Aiogram 3.x)"

    def handle(self, *args, **kwargs):
        logging.basicConfig(
            level=logging.INFO,
            format="%(asctime)s - %(name)s - %(levelname)s - %(message)s"
        )
        logger = logging.getLogger(__name__)
        logger.info("🚀 Starting Telegram Bot...")

        try:
            asyncio.run(self.start_bot())
        except (KeyboardInterrupt, SystemExit):
            logger.info("🛑 Bot stopped.")

    async def start_bot(self):
        # 1. Register Middlewares
        # Throttling first to drop spam before DB hits
        dp.message.middleware(ThrottlingMiddleware(limit=1)) 
        
        # Auth middleware injects User object
        dp.update.outer_middleware(DjangoUserMiddleware())

        # 2. Register Routers
        dp.include_router(main_router)

        # 3. Start Polling
        await bot.delete_webhook(drop_pending_updates=True)
        await dp.start_polling(bot)