from aiogram.types import InlineKeyboardMarkup, InlineKeyboardButton
from aiogram.utils.keyboard import InlineKeyboardBuilder

def get_main_menu_keyboard(is_affiliate: bool = False):
    builder = InlineKeyboardBuilder()
    
    if is_affiliate:
        builder.button(text="📢 Active Campaigns", callback_data="cmd_campaigns")
        builder.button(text="💰 My Wallet", callback_data="cmd_wallet")
    
    builder.button(text="ℹ️ Help", callback_data="cmd_help")
    builder.adjust(1)
    return builder.as_markup()

def get_campaigns_keyboard(campaigns):
    """
    Generates a list of campaigns.
    :param campaigns: List of Campaign objects (from Django)
    """
    builder = InlineKeyboardBuilder()
    
    for campaign in campaigns:
        # Callback data format: get_link:<campaign_id>
        builder.button(
            text=f"{campaign.title} - ${campaign.payout_per_action}", 
            callback_data=f"get_link:{campaign.id}"
        )
    
    builder.button(text="🔙 Back", callback_data="menu_main")
    builder.adjust(1)
    return builder.as_markup()