from django.contrib import admin
from .models import BotConfig

@admin.register(BotConfig)
class BotConfigAdmin(admin.ModelAdmin):
    list_display = ("__str__", "is_active", "updated_at")
    list_editable = ("is_active",)
    
    # Restrict permissions to ensure it acts like a singleton in the UI
    def has_add_permission(self, request):
        # Disable "Add" button if an instance already exists
        if BotConfig.objects.exists():
            return False
        return True

    def has_delete_permission(self, request, obj=None):
        # Prevent deleting the configuration
        return False