from celery import shared_task
import logging

logger = logging.getLogger(__name__)

@shared_task(bind=True, max_retries=1)
def process_import_task(self, job_id):
    """
    Celery task wrapper for the Excel Processor service.
    """
    # ------------------------------------------------------------------
    # FIX: Import inside the function to avoid Circular Dependency 
    # and AppRegistryNotReady errors during Django startup.
    # ------------------------------------------------------------------
    from .services import ExcelProcessor  
    
    logger.info(f"Starting Import Job: {job_id}")
    try:
        processor = ExcelProcessor(job_id)
        processor.run()
        logger.info(f"Finished Import Job: {job_id}")
    except Exception as e:
        logger.error(f"Critical failure in task for Job {job_id}: {e}")
        # Optional: self.retry(exc=e, countdown=60)
        raise e