from rest_framework import serializers
from .models import ImportJob

class ImportJobSerializer(serializers.ModelSerializer):
    status_display = serializers.CharField(source='get_status_display', read_only=True)
    campaign_name = serializers.CharField(source='campaign.title', read_only=True)

    class Meta:
        model = ImportJob
        fields = [
            'id', 'file', 'campaign', 'campaign_name', 
            'status', 'status_display', 'processing_log', 'created_at'
        ]
        read_only_fields = ['status', 'processing_log', 'created_at']