from django.db import models
from django.utils.translation import gettext_lazy as _
from apps.common.models import TimeStampedModel

class ImportJob(TimeStampedModel):
    class Status(models.TextChoices):
        PENDING = 'PENDING', _('Pending')
        PROCESSING = 'PROCESSING', _('Processing')
        COMPLETED = 'COMPLETED', _('Completed')
        FAILED = 'FAILED', _('Failed')

    file = models.FileField(upload_to='data_imports/%Y/%m/%d/')
    campaign = models.ForeignKey(
        'campaigns.Campaign', 
        on_delete=models.PROTECT,
        related_name='import_jobs',
        help_text="The campaign associated with this batch of users."
    )
    status = models.CharField(
        max_length=20, 
        choices=Status.choices, 
        default=Status.PENDING
    )
    # Log summary: { "total": 100, "success": 90, "errors": ["Row 5: User not found"] }
    processing_log = models.JSONField(default=dict, blank=True)
    
    def __str__(self):
        return f"Job {self.id} - {self.campaign.title} ({self.status})"