from django.urls import path
from rest_framework_simplejwt.views import TokenRefreshView
from .views import SendOTPView, VerifyOTPView, MeView

urlpatterns = [
    # 1. Login Flow (Admin & User)
    path('auth/send-otp/', SendOTPView.as_view(), name='send-otp'),
    path('auth/verify-otp/', VerifyOTPView.as_view(), name='verify-otp'),

    # 2. Token Management
    path('auth/refresh/', TokenRefreshView.as_view(), name='token_refresh'),

    # 3. User Profile
    path('users/me/', MeView.as_view(), name='user-me'),
]